<?php
/**
 * ACCOUNT SYSTEM - ULTRA MEMORY SHIELD & SESSION GUARD
 * Reforço contra erro de estouro de RAM e blindagem de Logout Acidental.
 */

// 1. Reforço de Memória e Tempo de Execução
@ini_set('memory_limit', '512M');
@ini_set('max_execution_time', '60');

// 2. Blindagem de Sessão (Impede retorno involuntário para login.php)
if (session_status() === PHP_SESSION_NONE) {
    @ini_set('session.gc_maxlifetime', 86400); // Persistência de 24h
    session_start();
}

// 3. Verificação Antecipada de Segurança
// Se a sessão sumir por erro do servidor, tentamos segurar o script aqui
if (!isset($_SESSION['username'])) {
    // Caso queira permitir que o header.php trate, deixe passar, 
    // mas se houver erro crítico de redirecionamento, verifique o session.php
}

// 4. Blindagem de Buffer com Compressão
if (ob_get_level() === 0) {
    ob_start("ob_gzhandler") || ob_start();
}

// 5. Coleta de lixo preventiva
gc_enable();
gc_collect_cycles();

require_once "session.php";
$pagename = "My Account";
require_once "header.php";
require_once "config.php";

/**
 * BLINDAGEM DE DADOS DA API
 * Execução isolada para proteger a memória global
 */
$shield = (function() use ($get_dns, $username, $password) {
    // Sanitização de URL para evitar quebras
    $url = trim($get_dns) . "/player_api.php?username=" . urlencode($username) . "&password=" . urlencode($password);
    
    $ch = curl_init();
    curl_setopt_array($ch, [
        CURLOPT_URL => $url,
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_FOLLOWLOCATION => true,
        CURLOPT_TIMEOUT => 8, // Aumentado levemente para evitar timeout em conexões lentas
        CURLOPT_CONNECTTIMEOUT => 4,
        CURLOPT_ENCODING => "", // Aceita compressão da API (economiza RAM)
        CURLOPT_USERAGENT => 'IPTV_Shield_Ultra_v2_2026'
    ]);
    
    $raw = curl_exec($ch);
    $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
    curl_close($ch);
    
    // Se a API falhar ou retornar erro, não quebramos o script
    if ($httpCode !== 200 || !$raw) {
        return ['u' => 'N/A', 's' => 'Error', 'e' => null];
    }

    // Decodifica e libera a string bruta imediatamente
    $json = json_decode($raw, true);
    $raw = null; 
    unset($raw); 

    // Extrai apenas o necessário do user_info
    $info = $json["user_info"] ?? null;
    $json = null;
    unset($json); 

    $res = [
        'u' => $info["username"] ?? 'N/A',
        's' => $info["status"] ?? 'Inactive',
        'e' => $info["exp_date"] ?? null
    ];
    
    $info = null;
    unset($info);
    return $res;
})();

$acc_user   = $shield['u'];
$acc_active = $shield['s'];
$exp        = $shield['e'];

// Lógica de Expiração
if (is_null($exp) || $exp === "null" || empty($exp)) {
    $expire = "ILIMITADO";
} else {
    $expire = is_numeric($exp) ? gmdate("d/m/Y", (int)$exp) : $exp;
}

// Limpeza de rastro
unset($shield);
gc_collect_cycles();
?>

<style>
:root { --accent: #00ffe7; --glass: rgba(30, 34, 48, 0.85); }
body { background: linear-gradient(135deg, #181c24 0%, #23283b 100%); color: #f1f1f1; font-family: "Inter", sans-serif; margin: 0; padding: 0; min-height: 100vh; }
.account-container { display: flex; flex-direction: column; align-items: center; padding: 20px; }
.topmoviestext2 { display: flex; align-items: center; justify-content: center; gap: 32px; margin-bottom: 28px; width: 100%; flex-wrap: wrap; }
.topmoviestext2 .item { display: flex; flex-direction: column; align-items: center; }
.topmoviestext2 .item img { width: 110px; height: 110px; border-radius: 50%; box-shadow: 0 8px 32px 0 rgba(0,0,0,0.3); background: rgba(255,255,255,0.05); border: 3px solid #23283b; }
.notification-heading { font-size: 2.1rem; font-weight: 700; margin-bottom: 8px; color: #fff; text-shadow: 0 2px 16px rgba(0,255,231,0.6); }
.notification-text { font-size: 1.1rem; color: #b3eaff; text-align: center; max-width: 350px; opacity: 0.9; }
.acc_id_sec { background: var(--glass); box-shadow: 0 8px 32px 0 rgba(0,0,0,0.4); border-radius: 32px; border: 1.5px solid rgba(255,255,255,0.1); padding: 35px; width: 100%; max-width: 410px; display: flex; flex-direction: column; gap: 15px; backdrop-filter: blur(10px); }
.acc_id_sec p { font-size: 1.1rem; margin: 0; color: #f1f1f1; }
.acc_id_sec strong { color: var(--accent); text-shadow: 0 0 8px rgba(0,255,231,0.4); text-transform: uppercase; }
.status { font-weight: 700; padding: 4px 15px; border-radius: 12px; background: linear-gradient(90deg, var(--accent) 0%, #0d4d5f 100%); color: #181c24; font-size: 0.9rem; margin-left: 5px; }
.status.inactive { background: linear-gradient(90deg, #ff0055 0%, #630a27 100%); color: #fff; }
@media (max-width: 767px) { .notification-heading { font-size: 1.5rem; } .topmoviestext2 .item img { width: 80px; height: 80px; } .acc_id_sec { padding: 25px; margin: 0 10px; } }
</style>

<div class="account-container">
    <div class="topmoviestext2">
        <div class="item">
            <h4 class="notification-heading">MINHA CONTA</h4>
            <p class="notification-text">Detalhes da sua assinatura e expiração.</p>
        </div>
        <div class="item">
            <img src="assets/images/adminimg.png" alt="Avatar">
        </div>
    </div>
    <div class="acc_id_sec">
        <p><strong>USUÁRIO:</strong> <?php echo htmlspecialchars($acc_user); ?></p>
        <p><strong>VALIDADE:</strong> <?php echo htmlspecialchars($expire); ?></p>
        <p><strong>STATUS:</strong> 
            <?php if (strtolower($acc_active) == "active"): ?>
                <span class="status">Ativa</span>
            <?php else: ?>
                <span class="status inactive">Inativa</span>
            <?php endif; ?>
        </p>
    </div>
</div>

<script>
$(function() {
    $("#myaccount_nav").addClass("active_menu");
});
</script>

<?php
// Limpeza Final e envio do buffer
unset($acc_user, $acc_active, $exp, $expire, $pagename);
gc_collect_cycles();
if (ob_get_level() > 0) ob_end_flush();
?>